<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class UserController extends Controller
{
    /**
     * Get user's own data
     */
    public function getUserData(Request $request)
    {
        $user = $request->user();

        return response()->json([
            'success' => true,
            'data' => [
                'id' => $user->id,
                'email' => $user->email,
                'phone' => $user->phone,
                'role' => $user->role,
                'is_approved' => $user->is_approved,
                'created_at' => $user->created_at,
                'updated_at' => $user->updated_at,
            ],
        ]);
    }

    /**
     * Update user's own data
     */
    public function updateUserData(Request $request)
    {
        $user = $request->user();

        $validated = $request->validate([
            'phone' => 'sometimes|string|unique:users,phone,' . $user->id . '|max:20',
            'password' => 'sometimes|string|min:6|confirmed',
        ]);

        if (isset($validated['phone'])) {
            $user->phone = $validated['phone'];
        }

        if (isset($validated['password'])) {
            $user->password = bcrypt($validated['password']);
        }

        $user->save();

        return response()->json([
            'success' => true,
            'message' => 'Profile updated successfully',
            'data' => [
                'id' => $user->id,
                'email' => $user->email,
                'phone' => $user->phone,
                'role' => $user->role,
                'is_approved' => $user->is_approved,
            ],
        ]);
    }
}
