<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Create admin user
        User::create([
            'email' => 'admin@voterlist.com',
            'phone' => '+1234567890',
            'password' => bcrypt('admin123'),
            'role' => 'admin',
            'is_approved' => true,
        ]);

        // Create sample regular user (not approved)
        User::create([
            'email' => 'user@example.com',
            'phone' => '+9876543210',
            'password' => bcrypt('user123'),
            'role' => 'user',
            'is_approved' => false,
        ]);
    }
}
