<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

// Public routes
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Protected routes - require authentication with Sanctum
Route::middleware('auth:sanctum')->group(function () {
    // Logout route
    Route::post('/logout', [AuthController::class, 'logout']);
    
    // Get current user info
    Route::get('/me', [AuthController::class, 'me']);

    // Admin routes - require admin role
    Route::middleware('admin')->prefix('admin')->group(function () {
        Route::get('/users', [AdminController::class, 'getAllUsers']);
        Route::get('/users/pending', [AdminController::class, 'getPendingUsers']);
        Route::post('/users/{id}/approve', [AdminController::class, 'approveUser']);
        Route::post('/users/{id}/reject', [AdminController::class, 'rejectUser']);
        Route::delete('/users/{id}', [AdminController::class, 'deleteUser']);
    });

    // User routes - require approved status
    Route::middleware('approved')->prefix('user')->group(function () {
        Route::get('/profile', [UserController::class, 'getUserData']);
        Route::put('/profile', [UserController::class, 'updateUserData']);
    });
});
